# -*- coding: utf-8 -*-
"""
output.py
数値出力
"""

import os
import numpy as np

Y0 = 10000

# 移動平均出力, ファイル名の頭に"ma_"がつく
def ma(fndata, idata0, idata1, ma, n0data, n1data):
    for idata in range(idata0, idata1 + 1):
        # ファイル名
        fn = 'ma_' + os.path.basename(fndata[idata]) + '.txt'
        with open(fn, 'wt', encoding='utf-8') as fp:
            n0 = n0data[idata]  # 開始年
            n1 = n1data[idata]  # 終了年
            fp.write('%d %d\n' % (n1 - n0 + 1, n0 - Y0))  # データ数, 開始年(西暦)
            for n in range(n0, n1 + 1):
                fp.write('%.1f\n' % (ma[idata][n] * 100))  # 0.01mm単位

# データ間平均出力
def average(fn, fmean, n0data, n1data):
    with open(fn, 'wt', encoding='utf-8') as fp:
        n0 = np.min(n0data)  # 開始年の最小
        n1 = np.max(n1data)  # 終了年の最大
        fp.write('%d %d\n' % (n1 - n0 + 1, n0 - Y0))  # データ数, 開始年(西暦)
        for n in range(n0, n1 + 1):
            fp.write('%.1f\n' % (fmean[n] * 100))   # 0.01mm単位

# r/t/y行列出力
def rty(fn, ndata, r, t, y):
    with open(fn, 'wt', encoding='utf-8') as fp:
        # r
        _rty_header(fp, ndata, 'r')
        _rty_body(fp, ndata, r, y, '%7.3f')
        fp.write('\n')

        # t
        _rty_header(fp, ndata, 't')
        _rty_body(fp, ndata, t, y, '%7.3f')
        fp.write('\n')

        # y
        _rty_header(fp, ndata, 'y')
        _rty_body(fp, ndata, y, y, '%7d')

# (private) header
def _rty_header(fp, ndata, c):
    fp.write('  %s' % c)
    for jdata in range(ndata):
        fp.write('    %3d' % (jdata + 1))
    fp.write('\n')

# (private) body
def _rty_body(fp, ndata, f2d, y, fmt):
    for idata in range(ndata):
        fp.write('%3d' % (idata + 1))
        for jdata in range(ndata):
            if idata == jdata:
                fp.write('       ')
            elif y[idata][jdata] == 0:
                fp.write('      0')
            else:
                fp.write(fmt % f2d[idata][jdata])
        fp.write('\n')

# 照合
def compare(fn, cmp):
    if (fn == None) or (cmp == None) or (len(cmp) == 0):
        return

    with open(fn, 'wt', encoding='utf-8') as fp:
        for item in cmp:
            fp.write('%d %d %.6f %.6f\n' % (item[0], item[1], item[2], item[3]))

# r/t統計出力, 最小,最大,平均（対角成分除く）
def statis(ndata, r, t):
    ndmask = (np.identity(ndata) == 0)  # 非対角マスク
    rmin  = np.min(r, initial=+1, where=ndmask)
    rmax  = np.max(r, initial=-1, where=ndmask)
    rmean = np.mean(r, where=ndmask)
    tmin  = np.min(t, initial=1000, where=ndmask)
    tmax  = np.max(t, initial=0, where=ndmask)
    tmean = np.mean(t, where=ndmask)
    print('r: %9.6f %9.6f %9.6f' % (rmin, rmean, rmax))
    print('t: %9.6f %9.6f %9.6f' % (tmin, tmean, tmax))
