# -*- coding: utf-8 -*-
"""
年輪データ解析
mnsp.py
2025年8月
"""

import os, sys
import numpy as np
import utils, plot, output

Y0 = 10000   # 紀元前を正の値にするためのゲタ
YEARDIM = 2 * Y0

def main(argv):
    # データファイル名, 拡張子'.txt'省略, 順にデータ番号=0,1,2,...となる
    fndata = [
 
    # (1) 暦年標準パターンA
    #'A',
    #'A_raw_average',
    #'A_std_average',
    #'A-1',
    #'A-2',
    #'A-3',
    #'A-4',
    #'A-5',
    #'A-6',
    #'A-7',
	'A-4-01', 'A-4-02', 'A-4-03', 'A-4-04', 'A-4-05', 'A-4-06', 'A-4-07', 'A-4-08', 'A-4-09', 'A-4-10', 'A-4-11', 'A-4-12', 'A-4-13', 'A-4-14', 'A-4-15', 'A-4-16', 'A-4-17',
	#'A-5-01', 'A-5-02', 'A-5-03', 'A-5-04', 'A-5-05', 'A-5-06', 'A-5-07', 'A-5-08', 'A-5-09', 'A-5-10', 'A-5-11', 'A-5-12', 'A-5-13',
	#'A-6-01', 'A-6-02', 'A-6-03', 'A-6-04', 'A-6-05', 'A-6-06', 'A-6-07', 'A-6-08', 'A-6-09', 'A-6-10', 'A-6-11', 'A-6-12', 'A-6-13', 'A-6-14', 'A-6-15',
	#'A-7-01', 'A-7-02', 'A-7-03', 'A-7-04', 'A-7-05', 'A-7-06', 'A-7-07', 'A-7-08', 'A-7-09', 'A-7-10', 'A-7-11', 'A-7-12', 'A-7-13', 'A-7-14', 'A-7-15',

    # (2) 暦年標準パターンD
    #'D',
    #'D_raw_average',
    #'D_std_average',
    #'D-1',
    #'D-2',
    #'D-3',
	#'D-1-01', 'D-1-02', 'D-1-03', 'D-1-04', 'D-1-05', 'D-1-06', 'D-1-07', 'D-1-08', 'D-1-09', 'D-1-10', 'D-1-11', 'D-1-12',
    #'D-2-01', 'D-2-02', 'D-2-03', 'D-2-04',
	#'D-3-01', 'D-3-02', 'D-3-03', 'D-3-04', 'D-3-05', 'D-3-06',

    # (3) 暦年標準パターンE
    #'E',
    #'E_raw_average',
    #'E_std_average',
	#'E-01', 'E-02', 'E-03', 'E-04', 'E-05', 'E-06', 'E-07', 'E-08', 'E-09', 'E-10', 'E-11', 'E-12', 'E-13', 'E-14', 'E-15', 'E-16', 'E-17', 'E-18', 'E-19', 'E-20', 'E-21', 'E-22',

    # (4) 暦年標準パターンF
    #'F',
    #'F_raw_average',
    #'F_std_average',
    #'F-01', 'F-02', 'F-03', 'F-04', 'F-05', 'F-06', 'F-07', 'F-08', 'F-09', 'F-10', 'F-11',

    # (5) 木曽ヒノキ暦年標準パターン
    #'KISO',
    #'KISO_raw_average',
    #'KISO_std_average',
    #'K-1',
    #'K-2',
    #'K-3',
    #'K-4',
    #'K-5',
    #'K-6',
    #'K-7',
    #'K-1-01', 'K-1-02',
    #'K-2-01', 'K-2-02', 'K-2-03', 'K-2-04',
    #'K-3-01', 'K-3-02', 'K-3-03', 'K-3-04', 'K-3-05', 'K-3-06', 'K-3-07', 'K-3-08', 'K-3-09', 'K-3-10', 'K-3-11', 'K-3-12',
    #'K-4-01', 'K-4-02', 'K-4-03', 'K-4-04', 'K-4-05', 'K-4-06',
    #'K-5-01', 'K-5-02', 'K-5-03', 'K-5-04', 'K-5-05', 'K-5-06', 'K-5-07', 'K-5-08', 'K-5-09',
    #'K-6-01', 'K-6-02', 'K-6-03', 'K-6-04',
    #'K-7-01', 'K-7-02', 'K-7-03', 'K-7-04', 'K-7-05', 'K-7-06',

    # (6) 埋木15点年輪データ
    #'UMEKI15',
    #'UMEKI15_raw_average',
    #'UMEKI15_std_average',
    #'U-01', 'U-02', 'U-03', 'U-04', 'U-05', 'U-06', 'U-07', 'U-08', 'U-09', 'U-10', 'U-11', 'U-12', 'U-13', 'U-14', 'U-15',

    # (7) 補足暦年標準パターン
    #'HOSOKU',
    #'HOSOKU_raw_average',
    #'HOSOKU_std_average',
    #'H-1',
    #'H-2',
    #'H-1-01', 'H-1-02', 'H-1-03', 'H-1-04', 'H-1-05', 'H-1-06', 'H-1-07', 'H-1-08', 'H-1-09', 'H-1-10', 'H-1-11',
    #'H-2-01', 'H-2-02', 'H-2-03', 'H-2-04',

    # (8) 全データパターン
    #'ALL_std_average',

    # 開始年不明データ
    #'horyuji',
    #'katuyama',
    #'ishizuka',
    #'ikegami-1',
    #'ikegami-2',
    #'ikegami-3',
    #'ikegami-4',
    #'ikegami-5',

    # その他のデータ
    #'foo'
    #'bar'
    ]
    #print(fndata)

    # データ数
    ndata = len(fndata)
    print('data =', ndata)
    if ndata <= 0:
        print('>>> no.data.')
        sys.exit()

	# 年輪データ配列
    a = np.zeros((ndata, YEARDIM), dtype=np.float64)  # 原データ
    b = np.zeros((ndata, YEARDIM), dtype=np.float64)  # 標準化後
    n0data = np.zeros(ndata, dtype=np.int32)          # 開始年(Y0補正後)
    n1data = np.zeros(ndata, dtype=np.int32)          # 終了年(Y0補正後)

	# データファイルを読み込む
    dir = 'data'
    for idata, fn in enumerate(fndata):
        path = os.path.join(dir, fn) + '.txt'
        n0data[idata], n1data[idata] = utils.read_data(path, a[idata])

    # 標準化(移動平均)計算
    lma = 5   # 移動量(1/3/5/7, 通常5)
    div = 1   # 割り算するか(0/1, 通常1)
    for idata in range(ndata):
        if (lma == 1) and (div == 0):
            b[idata] = a[idata].copy()  # 何もせずにコピーする（raw_average作成用）
        else:
            utils.ma(a[idata], b[idata], n0data[idata], n1data[idata], lma, div)

    # データ平均計算
    bmean = np.zeros(YEARDIM, dtype=np.float64)
    utils.average(ndata, b, bmean, n0data, n1data)

    # r/t/y行列計算
    r = np.zeros((ndata, ndata), dtype=np.float64)  # r
    t = np.zeros((ndata, ndata), dtype=np.float64)  # t
    y = np.zeros((ndata, ndata), dtype=np.int32)    # y(重複年数)
    for idata in range(ndata):
        for jdata in range(ndata):
            n0 = max(n0data[idata], n0data[jdata])  # 共通開始年
            n1 = min(n1data[idata], n1data[jdata])  # 共通終了年
            if (n0 < n1):
                r[idata, jdata] = np.corrcoef(b[idata, n0: n1 + 1], b[jdata, n0: n1 + 1])[0, 1]  # 相関係数は(0,1)または(1,0)
                t[idata, jdata] = utils.tf(r[idata, jdata], n1 - n0 + 1)
                y[idata, jdata] = max(n1 - n0 + 1, 0)
    
    # 照合, 照合したときのみ照合の図形出力が可能になる
    cmp = cmpfn = None
    if 1:
        if ndata > 1:
            idata1 = 0; idata1 = max(0, min(ndata - 1, idata1))  # 開始年既知のデータ番号
            idata2 = 1; idata2 = max(0, min(ndata - 1, idata2))  # 開始年未知のデータ番号
            max_offset = 100  # 開始年変動の最大値(正負)
            min_overlap = 10  # 最小重複年数
            if ((n0data[idata1] > n1data[idata2]) or (n1data[idata1] < n0data[idata2])):
                print('>>> compare: no overlapped years.')  # 重複年がないので計算できない
            else:
                cmp = utils.compare(b[idata1], b[idata2], n0data[idata1], n1data[idata1], n0data[idata2], n1data[idata2], max_offset, min_overlap)
                cmpfn = [fndata[idata1], fndata[idata2], n1data[idata2] - Y0]

    # r/t統計数値出力
    if ndata > 1:
        output.statis(ndata, r, t)

    # 数値出力
    _output(fndata, ndata, b, bmean, r, t, y, cmp, n0data, n1data)

    # 図形出力
    _plot(fndata, ndata, a, b, bmean, r, t, cmp, cmpfn, n0data, n1data)

# (private) 図形出力
# 図形出力する項目を"if 1:"とする
def _plot(fndata, ndata, a, b, bmean, r, t, cmp, cmpfn, n0data, n1data):
    # (1) 原データ
    if 1:
        figtitle = 'raw data'   # ウィンドウタイトル
        figsize = (8, 3)        # ウィンドウサイズ(inch)
        idata0 = 0; idata0 = max(0, min(ndata - 1, idata0))  # 開始データ番号
        idata1 = 0; idata1 = max(0, min(ndata - 1, idata1))  # 終了データ番号
        year0  = 1800  # 開始年
        year1  = 1900  # 終了年
        xdiv   = 50    # 横軸分割量
        ymin   = 0.0   # 縦軸最小[mm]
        ymax   = 2.0   # 縦軸最大[mm]
        ydiv   = 4     # 縦軸分割数
        assert (idata0 <= idata0) and (year0 < year1) and (xdiv > 0) and (ymin < ymax) and (ydiv > 0)
        title = 'raw data, #%d-#%d' % (idata0 + 1, idata1 + 1) if (idata0 != idata1) else 'raw data, #%d' % (idata0 + 1)
        plot.fyear(figtitle, figsize, idata0, idata1, a, n0data, n1data, year0, year1, xdiv, ymin, ymax, ydiv, fndata, title)

    # (2) 標準化
    if 1:
        figtitle = 'standardization'  # ウィンドウタイトル
        figsize = (8, 3)              # ウィンドウサイズ(inch)
        idata0 = 0; idata0 = max(0, min(ndata - 1, idata0))  # 開始データ番号
        idata1 = 0; idata1 = max(0, min(ndata - 1, idata1))  # 終了データ番号
        year0  = 1800  # 開始年
        year1  = 1900  # 終了年
        xdiv   = 50    # 横軸分割量
        ymin   = 0.5   # 縦軸最小
        ymax   = 1.5   # 縦軸最大
        ydiv   = 2     # 縦軸分割数
        assert (idata0 <= idata0) and (year0 < year1) and (xdiv > 0) and (ymin < ymax) and (ydiv > 0)
        title = 'standardization, ' + (('#%d-#%d' % (idata0 + 1, idata1 + 1)) if (idata0 != idata1) else ('#%d' % (idata0 + 1)))
        plot.fyear(figtitle, figsize, idata0, idata1, b, n0data, n1data, year0, year1, xdiv, ymin, ymax, ydiv, fndata, title)

    # (3) 標準化データの平均
    if 1:
        figtitle = 'average of standardization'   # ウィンドウタイトル
        figsize = (8, 3)                          # ウィンドウサイズ(inch)
        year0 = 1800  # 開始年
        year1 = 1900  # 終了年
        xdiv  = 50    # 横軸分割量
        ymin  = 0.5   # 縦軸最小
        ymax  = 1.5   # 縦軸最大
        ydiv  = 2     # 縦軸分割数
        assert (year0 < year1) and (xdiv > 0) and (ymin < ymax) and (ydiv > 0)
        title = 'average of standardization, data=%d' % ndata
        f = np.reshape(bmean, (1, -1))
        plot.fyear(figtitle, figsize, 0, 0, f, [np.min(n0data)], [np.max(n1data)], year0, year1, xdiv, ymin, ymax, ydiv, None, title)

    # (4) 散布図
    if 1:
        figtitle = 'scatter'   # ウィンドウタイトル
        figsize = (8, 4)       # ウィンドウサイズ(inch)
        idata0 = 0; idata0 = max(0, min(ndata - 1, idata0))  # 開始データ番号  
        idata1 = 1; idata1 = max(0, min(ndata - 1, idata1))  # 終了データ番号
        fmin   = 0.5  # 軸最小値
        fmax   = 1.5  # 軸最大値
        fdiv   = 2    # 軸分割数
        marker = 3    # マーカーサイズ   
        if (ndata > 1) and (idata0 < idata1):
            assert (fmin < fmax) and (fdiv > 0) and (marker > 0)
            plot.scatter(figtitle, figsize, idata0, idata1, b, t, n0data, n1data, fmin, fmax, fdiv, marker)

    # (5) r/tマップ
    if 1:
        figtitle = 'r/t'   # ウィンドウタイトル
        figsize = (8, 4)   # ウィンドウサイズ(inch)
        rmin = 0.0   # r最小値
        rmax = 0.6   # r最大値
        tmin = 0     # t最小値
        tmax = 10    # t最大値
        if ndata > 1:
            assert (rmin < rmax) and (tmin < tmax)
            plot.map(figtitle, figsize, ndata, r, t, rmin, rmax, tmin, tmax)

    # (6) r/tヒストグラム
    if 1:
        figtitle = 'histogram r/t'   # ウィンドウタイトル
        figsize = (8, 3)             # ウィンドウサイズ(inch)
        bins = 20    # 分割数
        rmin = 0.0   # r最小値
        rmax = 1.0   # r最大値
        tmin = 0     # t最小値
        tmax = 20    # t最大値
        if ndata > 1:
            assert (bins > 0) and (rmin < rmax) and (tmin < tmax)
            plot.histogram(figtitle, figsize, ndata, r, t, bins, rmin, rmax, tmin, tmax)

    # (7) 照合, 照合の計算をしたときのみ有効
    if 1:
        figtitle = 'compare'   # ウィンドウタイトル
        figsize = (8, 3)       # ウィンドウサイズ(inch)
        rt = 't'               # 'r' or 't'
        ymax = 10              # 縦軸最大値
        #ymax = None            # 縦軸自動設定
        if (cmp is not None) and (len(cmp) > 0):
            plot.compare(figtitle, figsize, cmp, rt, cmpfn, ymax)

    # (8) （テスト）移動平均年数(3/5/7)
    if 0:
        figtitle = 'test of moving average'   # ウィンドウタイトル
        figsize = (8, 3)                      # ウィンドウサイズ(inch)
        itest = 0; itest = max(0, min(ndata - 1, itest)) # テストデータ番号
        year0 = 1800  # 開始年
        year1 = 1900  # 終了年
        xdiv  = 50    # 横軸分割量
        ymin  = 0.0   # 縦軸最小
        ymax  = 2.0   # 縦軸最大
        ydiv  = 4     # 縦軸分割数
        div   = 0     # 割り算するか（0/1）
        lmalist = [1, 3, 5, 7]  # 移動平均年数リスト
        assert (year0 < year1) and (xdiv > 0) and (ymin < ymax) and (ydiv > 0)
        n0list = [n0data[itest]] * len(lmalist)
        n1list = [n1data[itest]] * len(lmalist)
        wk = np.zeros((len(lmalist), YEARDIM), dtype=np.float64)
        for i, lma in enumerate(lmalist):
            utils.ma(a[itest], wk[i], n0data[itest], n1data[itest], lma, div) # 移動平均計算
        title = 'test of moving average, data No. %d' % (itest + 1)
        plot.fyear(figtitle, figsize, 0, len(lmalist) - 1, wk, n0list, n1list, year0, year1, xdiv, ymin, ymax, ydiv, lmalist, title)

    # (9) （テスト）標準化データヒストグラム
    if 0:
        figtitle = 'histogram of standard data'   # ウィンドウタイトル
        figsize = (6, 3)                          # ウィンドウサイズ(inch)
        bins = 40    # 分割数
        xmin = 0.5   # 横軸最小値
        xmax = 1.5   # 横軸最大値
        b1d = np.reshape(b, -1)  # 1D化
        w = np.where(b1d != 0)   # 空データ除く
        f = b1d[w]
        plot.histo2(figtitle, figsize, f, bins, xmin, xmax)

    # (10) （テスト）データ年代情報
    if 0:
        figtitle = 'year of data'   # ウィンドウタイトル
        figsize = (6, 4)            # ウィンドウサイズ(inch)
        year0 = 1000   # 開始年
        year1 = 2000   # 終了年
        xdiv  = 100    # 横軸分割量
        plot.datastatis(figtitle, figsize, ndata, n0data, n1data, year0, year1, xdiv)

# (private) 数値出力
# 数値出力する項目を"if 1:"とする
def _output(fndata, ndata, b, bmean, r, t, y, cmp, n0data, n1data):
    # (1) 標準化, 指定したデータのみ
    if 1:
        idata0 = 0  # 開始データ番号
        idata1 = 0  # 終了データ番号
        idata0 = max(0, min(ndata - 1, idata0))
        idata1 = max(0, min(ndata - 1, idata1))
        output.ma(fndata, idata0, idata1, b, n0data, n1data)
        print('output: ma_***.txt')

    # (2) データ間平均
    if 1:
        fn = 'average.txt'  # ファイル名
        output.average(fn, bmean, n0data, n1data)
        print('output: %s' % fn)

    # (3) r/t/y行列
    if 1:
        if ndata > 1:
            fn = 'rty.log'  # ファイル名
            output.rty(fn, ndata, r, t, y)
            print('output: %s' % fn)

    # (4) 照合
    if 1:
        if (ndata > 1) and (cmp is not None):
            fn = 'compare.log'  # ファイル名
            output.compare(fn, cmp)
            print('output: %s' % fn)

# entry point
if __name__ == '__main__':
    main(sys.argv)
